//@author: vux
//@help: standard constant shader
//@tags: color
//@credits: 

Texture2D texture2d <string uiname="Texture";>;

// slider for input

float interpolation <string uiname="interpolation";> = 1.0;
float slider<string uiname="Repeats";> = 1;
bool repeat<string uiname="Clamp";> = 1;
float scale<string uiname="Scale";> = 1;
float twirl<string uiname="Twirl";> = 0;
float squeeze<string uiname="Squeeze";> = 1;
float zoom<string uiname="Zoom";> = 1;
float lens<string uiname="Lens";> = 0;
float offsetx<string uiname="x offset";> = 0;
float offsety<string uiname="y offset";> = 0;

// Helper functions
float2 cartesian(float2 coords)
{
    coords[0] -= (0.5 + offsetx);
    coords[1] -= (0.5 + offsety);
    return coords;
}
float2 polar(float2 coords)
{
    coords = coords / 2.0;
    coords += 0.5;
    return coords;
}

float2 cartToPolar(float2 coords)
{
    float mag = (length(coords)/0.5)*scale;
    // clamp it
    if (!(repeat))
    {
        mag = saturate(mag);
    }
    // angle = arc tangent of y/x
    float angle = atan2(coords[1], coords[0])*slider;
    angle = -(angle+1.57079633)/6.28319;
    
    mag = pow(mag, 1.0/squeeze)*zoom;	//squeeze & zoom
    mag = lerp(mag, mag*mag/sqrt(2.0), lens);	//fisheye/lens effect
    angle += (1.0 - smoothstep(-1.0, 1.0, mag))*twirl;     //twirl
    
    coords[0] = angle;
    coords[1] = mag;
    return coords;
}
float2 polarToCart(float2 coords)
{
    float mag = coords[1];
    float angle = -1.0*coords[0]*6.28319+1.57079633;

    coords[0] = mag*cos(angle);
    coords[1] = mag*sin(angle);
    return coords;
}

SamplerState g_samLinear <string uiname="Sampler State";>
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;
};

 
cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
};


cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float Alpha <float uimin=0.0; float uimax=1.0;> = 1; 
	float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
	float4x4 tTex <string uiname="Texture Transform"; bool uvspace=true; >;
	float4x4 tColor <string uiname="Color Transform";>;
};

struct VS_IN
{
	float4 PosO : POSITION;
	float4 TexCd : TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float4 TexCd: TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps Out = (vs2ps)0;
    Out.PosWVP  = mul(input.PosO,mul(tW,tVP));
    Out.TexCd = mul(input.TexCd, tTex);
    return Out;
}




float4 PSPolarCoordinates(vs2ps In): SV_Target

{
	
	 /*
     * for the conversion to polar coordinates we will offset the incoming
     * pixels coordinates to be in a cartesian plane with 0.0, 0.0 as the center
     * of the image and the upper left corner being -0.5, 0.5. From here we will
     * use those coordinates as a vector, getting the magnitude and the angle
     * using sweet sweet linear algebra. we clamp the radius to the size of the
     * image (1.0), and we use that and the angle in radians for our new color!
     */
     
    // convert to cartesian
    float2 coords;
    coords = cartesian(In.TexCd.xy);
    // do the algebra to get the angle and magnitude
    //rotate the whole thing 90 CCW (this is what Pshop does)
    coords = cartToPolar(coords);
    coords = lerp(In.TexCd.xy, coords, interpolation);

    float4 col = texture2d.Sample(g_samLinear,coords) * cAmb;
	col = mul(col, tColor);
	col.a *= Alpha;
    return col;
}

float4 PSCartCoordinates(vs2ps In): SV_Target
{
	
	
	float2 coords = In.TexCd.xy;
    coords[0] = saturate(coords[0])+0.5;
    coords[1] = saturate(coords[1]);
    coords = polarToCart(coords);
    coords = polar(coords);

    coords = lerp(In.TexCd.xy, coords, interpolation) + float2(offsetx, offsety);
	
	
	
	
	
	
    float4 col = texture2d.Sample(g_samLinear,coords) * cAmb;
	col = mul(col, tColor);
	col.a *= Alpha;
    return col;
}




technique10 CartesianToPolar
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSPolarCoordinates() ) );
	}
}


technique10 PolarToCartesian
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSCartCoordinates() ) );
	}
}

